<?php
require __DIR__ . '/auth.php';
requireLogin();

$dataDir = '../data/';
$storeFile = isset($_POST['storeFile']) ? $_POST['storeFile'] : null;
$index = isset($_POST['index']) ? intval($_POST['index']) : null;

if ($storeFile && file_exists($dataDir . $storeFile) && $index !== null) {
    $articles = json_decode(file_get_contents($dataDir . $storeFile), true);

    if (is_array($articles) && isset($articles[$index])) {
        unset($articles[$index]);
        $articles = array_values($articles);
        file_put_contents($dataDir . $storeFile, json_encode($articles, JSON_PRETTY_PRINT));
    }
}

header('Location: ../articles.php?store=' . urlencode($storeFile));
