<?php
require __DIR__ . '/auth.php';

// Wenn schon eingeloggt, direkt zur Startseite
if (currentUser()) {
    header('Location: start.php');
    exit;
}

$error    = '';
$username = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username'] ?? '');
    $password = $_POST['password'] ?? '';

    if ($username !== '' && $password !== '') {
        $stmt = $pdo->prepare('SELECT id, username, password FROM users WHERE username = :u');
        $stmt->execute([':u' => $username]);
        $user = $stmt->fetch();

        if ($user && password_verify($password, $user['password'])) {
            $_SESSION['user_id'] = (int)$user['id'];
            header('Location: start.php');
            exit;
        } else {
            $error = 'Benutzername oder Passwort ist falsch.';
        }
    } else {
        $error = 'Bitte Benutzername und Passwort eingeben.';
    }
}
?>
<!DOCTYPE html>
<html lang="de">
<head>
    <meta charset="UTF-8">
    <title>EKL – Anmeldung</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" href="css/style.css">
    <link rel="icon" href="icons/logo.png" type="image/png">
    <style>
        /* Gesamte Box mittig, orientiert an deinem Layout */
        .login-shell {
            max-width: 480px;
            margin: 3rem auto 2rem auto;
            padding: 0 1rem;
        }

        .login-card {
            background: #1f2937;
            border-radius: 0.9rem;
            padding: 2rem 2rem 1.75rem 2rem;
            box-shadow: 0 16px 40px rgba(15, 23, 42, 0.55);
        }

        .login-card h1 {
            font-size: 1.6rem;
            letter-spacing: 0.12em;
            text-align: center;
            margin-bottom: 1.75rem;
        }

        .login-card form {
            display: flex;
            flex-direction: column;
            gap: 1rem;
            margin: 0;
        }

        .login-group {
            display: flex;
            flex-direction: column;
        }

        .login-group label {
            font-size: 0.85rem;
            margin-bottom: 0.3rem;
            color: #e5e7eb;
        }

        .login-card input[type="text"],
        .login-card input[type="password"] {
            display: block;
            width: 100%;
            box-sizing: border-box;
            padding: 0.55rem 0.8rem;
            border-radius: 0.4rem;
            border: 1px solid #4b5563;
            background-color: #0f172a;
            color: #f9fafb;
            font-size: 0.95rem;
        }

        .login-card input::placeholder {
            color: #6b7280;
        }

        .login-error {
            background: rgba(248, 113, 113, 0.12);
            border: 1px solid rgba(248, 113, 113, 0.65);
            color: #fecaca;
            padding: 0.55rem 0.8rem;
            border-radius: 0.55rem;
            font-size: 0.85rem;
            margin-bottom: 0.25rem;
        }

        .login-submit {
            margin-top: 0.25rem;
        }

        .login-submit button {
            display: block;
            width: 100%;
            box-sizing: border-box;
            padding: 0.7rem;
            border: none;
            border-radius: 0.55rem;
            cursor: pointer;
            font-weight: 600;
            font-size: 0.95rem;
        }

        @media (max-width: 480px) {
            .login-card {
                padding: 1.5rem 1.4rem 1.4rem 1.4rem;
            }
        }
    </style>
</head>
<body>

<div id="app">
    <div class="login-shell">
        <div class="login-card">
            <h1>ANMELDUNG</h1>

            <?php if ($error): ?>
                <div class="login-error"><?= htmlspecialchars($error) ?></div>
            <?php endif; ?>

            <form method="post" action="login.php" novalidate>
                <div class="login-group">
                    <label for="username">Benutzername</label>
                    <input
                        type="text"
                        name="username"
                        id="username"
                        autocomplete="username"
                        required
                        value="<?= htmlspecialchars($username) ?>">
                </div>

                <div class="login-group">
                    <label for="password">Passwort</label>
                    <input
                        type="password"
                        name="password"
                        id="password"
                        autocomplete="current-password"
                        required>
                </div>

                <div class="login-submit">
                    <button type="submit">Anmelden</button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php include __DIR__ . '/footer.php'; ?>
</body>
</html>
