document.addEventListener("DOMContentLoaded", () => {
    const storeList = document.getElementById("storeList");

    // Geschäfte dynamisch laden
    const loadStores = async () => {
        const response = await fetch("data/stores.json");
        const stores = await response.json();
        renderStores(stores);
    };

    // Darstellung der Geschäfte
    const renderStores = (stores) => {
        storeList.innerHTML = ""; // Liste leeren
        stores.forEach((store, index) => {
            const li = document.createElement("li");
            li.classList.add("store-item");
            li.innerHTML = `
                <div class="store-info">
                    <img src="icons/${store.icon}" alt="${store.name}" class="store-icon">
                    <span>${store.name} (${store.articleCount || 0} Artikel)</span>
                </div>
                <div class="store-actions">
                    <a href="articles.php?store=${store.file}" class="view-store">Ansehen</a>
                    <button class="delete-store" data-index="${index}">Löschen</button>
                </div>
            `;
            storeList.appendChild(li);
        });
    };

    // Lösch-Button Event-Listener
    storeList.addEventListener("click", async (e) => {
        if (e.target.classList.contains("delete-store")) {
            const index = e.target.getAttribute("data-index");

            // AJAX-Löschanfrage senden
            const response = await fetch("php/delete_store.php", {
                method: "POST",
                headers: {
                    "Content-Type": "application/x-www-form-urlencoded",
                },
                body: `index=${index}`,
            });

            // Aktualisierte Liste laden, wenn erfolgreich
            if (response.ok) {
                const updatedStores = await response.json();
                renderStores(updatedStores);
            } else {
                alert("Das Geschäft konnte nicht gelöscht werden.");
            }
        }
    });

    // Beim Start Geschäfte laden
    loadStores();
});
