<!DOCTYPE html>
<html lang="de">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>EKL - Die Einkaufsliste</title>
    <link href="https://fonts.googleapis.com/css2?family=Orbitron:wght@700&display=swap" rel="stylesheet">
    <link rel="icon" href="icons/logo.png" type="image/png">
    <style>
        /* Konfetti-Styles */
        .confetti {
            position: fixed;
            width: 10px;
            height: 10px;
            background: #ff0000;
            pointer-events: none;
            animation: confettiFall linear forwards;
            z-index: 999;
        }

        @keyframes confettiFall {
    0% {
        transform: translateY(-100vh);
        opacity: 1;
    }
    100% {
        transform: translateY(100vh);
        opacity: 0;
    }
}

        /* Bestehende Styles bleiben unverändert */
        body {
            margin: 0;
            background: #000;
            overflow: hidden;
            display: flex;
            justify-content: center;
            align-items: center;
            flex-direction: column;
            height: 100vh;
            color: #fff;
            font-family: 'Orbitron', sans-serif;
        }

        .scene {
            perspective: 1000px;
        }

        .cube {
            position: relative;
            width: 100px;
            height: 100px;
            transform-style: preserve-3d;
        }

        @keyframes rotateIndividual1 {
            0% {
                transform: rotateX(0deg) rotateY(0deg);
            }
            50% {
                transform: rotateX(180deg) rotateY(90deg);
            }
            100% {
                transform: rotateX(360deg) rotateY(180deg);
            }
        }

        @keyframes rotateIndividual2 {
            0% {
                transform: rotateX(0deg) rotateY(0deg) rotateZ(0deg);
            }
            50% {
                transform: rotateX(90deg) rotateY(180deg) rotateZ(90deg);
            }
            100% {
                transform: rotateX(360deg) rotateY(360deg) rotateZ(360deg);
            }
        }

        @keyframes rotateIndividual3 {
            0% {
                transform: rotateY(0deg) rotateZ(0deg);
            }
            50% {
                transform: rotateY(180deg) rotateZ(180deg);
            }
            100% {
                transform: rotateY(360deg) rotateZ(360deg);
            }
        }

        @keyframes syncRotation {
            0% {
                transform: rotateX(0deg) rotateY(0deg);
            }
            100% {
                transform: rotateX(0deg) rotateY(0deg);
            }
        }

        @keyframes glowRed {
            0% {
                box-shadow: 0 0 10px rgba(255, 0, 0, 0.8);
            }
            100% {
                box-shadow: 0 0 30px rgba(255, 0, 0, 1);
            }
        }

        @keyframes glowBlue {
            0% {
                box-shadow: 0 0 10px rgba(0, 0, 255, 0.8);
            }
            100% {
                box-shadow: 0 0 30px rgba(0, 0, 255, 1);
            }
        }

        @keyframes glowYellow {
            0% {
                box-shadow: 0 0 10px rgba(255, 255, 0, 0.8);
            }
            100% {
                box-shadow: 0 0 30px rgba(255, 255, 0, 1);
            }
        }

        .cube#cube1 {
            animation: rotateIndividual1 3s linear, syncRotation 3s linear 3s forwards, glowBlue 1.3s infinite alternate;
        }

        .cube#cube2 {
            animation: rotateIndividual2 3s linear, syncRotation 3s linear 3s forwards, glowRed 1.3s infinite alternate;
        }

        .cube#cube3 {
            animation: rotateIndividual3 3s linear, syncRotation 3s linear 3s forwards, glowYellow 1.3s infinite alternate;
        }

        .cube .face {
            position: absolute;
            width: 100px;
            height: 100px;
            background: linear-gradient(to bottom right, rgba(255, 255, 255, 0.8), rgba(0, 0, 0, 0));
            border: 2px solid #fff;
        }
        
        .cube .face:nth-child(1) { transform: rotateY(0deg) translateZ(50px); }
        .cube .face:nth-child(2) { transform: rotateY(90deg) translateZ(50px); }
        .cube .face:nth-child(3) { transform: rotateY(180deg) translateZ(50px); }
        .cube .face:nth-child(4) { transform: rotateY(-90deg) translateZ(50px); }
        .cube .face:nth-child(5) { transform: rotateX(90deg) translateZ(50px); }
        .cube .face:nth-child(6) { transform: rotateX(-90deg) translateZ(50px); }

        .container {
            display: flex;
            gap: 20px;
        }

        .title, .link {
            opacity: 0;
            transition: opacity 2s ease;
        }

        .title {
            margin-top: 20px;
            font-size: 3rem;
            text-align: center;
            text-shadow: 0 0 10px rgba(255, 255, 255, 0.8),
                         0 0 20px rgba(255, 255, 255, 0.9),
                         0 0 30px rgba(255, 255, 255, 1);
            color: #fff;
        }

        .link {
            margin-top: 20px;
            font-size: 1.5rem;
            text-align: center;
            color: #fff;
            text-decoration: none;
            font-family: 'Orbitron', sans-serif;
            text-shadow: 0 0 10px rgba(255, 255, 255, 0.8),
                         0 0 20px rgba(255, 255, 255, 0.9),
                         0 0 30px rgba(255, 255, 255, 1);
        }

        .link:hover {
            text-shadow: 0 0 20px rgba(255, 255, 255, 1),
                         0 0 30px rgba(255, 255, 255, 1),
                         0 0 40px rgba(255, 255, 255, 1);
        }
    </style>
</head>
<body>
     <!-- Konfetti-Container -->
     <div id="confetti-container"></div>

    <div class="scene">
        <div class="container">
            <div class="cube" id="cube1">
                <div class="face" style="background: blue;"></div>
                <div class="face" style="background: blue;"></div>
                <div class="face" style="background: blue;"></div>
                <div class="face" style="background: blue;"></div>
                <div class="face" style="background: blue;"></div>
                <div class="face" style="background: blue;"></div>
            </div>
            <div class="cube" id="cube2">
                <div class="face" style="background: red;"></div>
                <div class="face" style="background: red;"></div>
                <div class="face" style="background: red;"></div>
                <div class="face" style="background: red;"></div>
                <div class="face" style="background: red;"></div>
                <div class="face" style="background: red;"></div>
            </div>
            <div class="cube" id="cube3">
                <div class="face" style="background: yellow;"></div>
                <div class="face" style="background: yellow;"></div>
                <div class="face" style="background: yellow;"></div>
                <div class="face" style="background: yellow;"></div>
                <div class="face" style="background: yellow;"></div>
                <div class="face" style="background: yellow;"></div>
            </div>
        </div>
    </div>
    <div class="title" id="title">Köhler & Lemke - EKL</div>
    <a href="start.php" class="link" id="link">Weiter zur Liste</a>
    <script>
         // Konfetti-Generator
function createConfetti() {
    const colors = [
    '#ff0000', // Rot
    '#00ff00', // Grün
    '#0000ff', // Blau
    '#ffff00', // Gelb
    '#ff00ff', // Magenta
    '#00ffff', // Cyan
    '#ff8000', // Orange
    '#8000ff', // Lila
    '#ff66b2', // Pink
    '#ffcc00', // Gold
    '#66ff66', // Hellgrün
    '#3399ff', // Helles Blau
    '#ff5050', // Helles Rot
    '#ff99ff', // Pastell-Pink
    '#ffff66', // Pastell-Gelb
    '#66ffff'  // Türkis
];

    // Das Container-Element für das Konfetti auswählen
    const container = document.getElementById('confetti-container');

    // Eine Schleife, die 500 Konfetti-Elemente erstellt
    for (let i = 0; i < 500; i++) {
    // Ein neues <div>-Element für das Konfetti erstellen
    const confetti = document.createElement('div');
    
    // Die Klasse 'confetti' für das Styling zuweisen
    confetti.className = 'confetti';

    // Zufällige horizontale Position zwischen 0% und 100% der Bildschirmbreite setzen
    confetti.style.left = Math.random() * 100 + 'vw';

    // Startposition des Konfettis leicht über dem sichtbaren Bereich setzen
    confetti.style.top = '-5vh';

    // Eine zufällige Farbe aus der `colors`-Liste zuweisen
    confetti.style.background = colors[Math.floor(Math.random() * colors.length)];

    // Zufällige Dauer für den Fall des Konfettis setzen (zwischen 2 und 5 Sekunden)
    confetti.style.animationDuration = Math.random() * 3 + 2 + 's';

    // Zufällige Verzögerung, damit nicht alle Konfetti gleichzeitig starten (zwischen 0 und 2 Sekunden)
    confetti.style.animationDelay = Math.random() * 2 + 's';

    // Das Konfetti-Element in den Container einfügen
    container.appendChild(confetti);

    // Event Listener: Sobald die Animation endet, das Konfetti aus dem DOM entfernen
    confetti.addEventListener('animationend', () => {
        confetti.remove();
    });
}

}
        

        // Beim Laden der Seite
        window.addEventListener('load', () => {
            createConfetti();
            
            // Bestehende Timeouts
            setTimeout(() => {
                title.style.opacity = 1;
            }, 3000);

            setTimeout(() => {
                link.style.opacity = 1;
            }, 3500);
        });
    </script>
</body>
</html>
