<?php
declare(strict_types=1);

// Stellt $pdo bereit
require_once __DIR__ . '/db.php';

session_name('EKLSESSION');
session_start();

/**
 * aktuellen User holen oder null
 */
function currentUser(): ?array
{
    static $user = null;

    if ($user !== null) {
        return $user;
    }

    if (empty($_SESSION['user_id'])) {
        return null;
    }

    global $pdo;

    $stmt = $pdo->prepare(
        'SELECT 
             id,
             username,
             email,
             first_name,
             last_name,
             password,
             text_color
         FROM users 
         WHERE id = :id
         LIMIT 1'
    );
    $stmt->execute([':id' => (int)$_SESSION['user_id']]);
    $user = $stmt->fetch();

    // Falls Session auf nicht mehr existierenden User zeigt
    if (!$user) {
        session_unset();
        session_destroy();
        $user = null;
        return null;
    }

    // Default-Farbe setzen, falls noch leer / null
    if (empty($user['text_color'])) {
        $user['text_color'] = '#3b82f6';
    }

    return $user;
}

/**
 * Für jede geschützte Seite aufrufen.
 * Nicht eingeloggt → immer auf login.php.
 */
function requireLogin(): void
{
    if (currentUser() === null) {
        header('Location: login.php');
        exit;
    }
}
