<?php
require __DIR__ . '/auth.php';
requireLogin();

header('Content-Type: application/json');

// JSON-Daten aus dem POST-Request auslesen
$data = json_decode(file_get_contents('php://input'), true);

// Überprüfen, ob die erforderlichen Daten übergeben wurden
if (!isset($data['newOrder']) || !isset($data['storeFile'])) {
    http_response_code(400);
    echo json_encode(['message' => 'Ungültige Daten übermittelt.']);
    exit;
}

$storeFile = '../data/' . $data['storeFile'];
$newOrder = $data['newOrder'];

// Überprüfen, ob die Datei existiert
if (!file_exists($storeFile)) {
    http_response_code(404);
    echo json_encode(['message' => 'Die Datei für das Geschäft wurde nicht gefunden.']);
    exit;
}

// Bestehende Artikel laden
$articles = json_decode(file_get_contents($storeFile), true);

// Überprüfen, ob die Artikel gültig sind
if (!is_array($articles)) {
    http_response_code(500);
    echo json_encode(['message' => 'Fehler beim Laden der Artikeldaten.']);
    exit;
}

// Artikel in der neuen Reihenfolge sortieren
$sortedArticles = [];
foreach ($newOrder as $index) {
    if (isset($articles[$index])) {
        $sortedArticles[] = $articles[$index];
    }
}

// Neue Reihenfolge in die JSON-Datei speichern
if (file_put_contents($storeFile, json_encode($sortedArticles, JSON_PRETTY_PRINT))) {
    http_response_code(200);
    echo json_encode(['message' => 'Reihenfolge erfolgreich gespeichert.']);
} else {
    http_response_code(500);
    echo json_encode(['message' => 'Fehler beim Speichern der neuen Reihenfolge.']);
}
?>
