<?php
declare(strict_types=1);

require __DIR__ . '/../auth.php';
requireLogin();

$itemId    = isset($_POST['item_id']) ? (int)$_POST['item_id'] : 0;
$storeFile = $_POST['storeFile'] ?? ($_POST['store'] ?? null);

if ($itemId > 0) {

    // Bildpfad holen
    $stmt = $pdo->prepare('SELECT image_path FROM items WHERE id = :id');
    $stmt->execute([':id' => $itemId]);
    $item = $stmt->fetch();

    if ($item && !empty($item['image_path'])) {
        $filePath = __DIR__ . '/../uploads/items/' . $item['image_path'];
        if (is_file($filePath)) {
            @unlink($filePath);
        }
    }

    // Artikel löschen
    $stmt = $pdo->prepare('DELETE FROM items WHERE id = :id');
    $stmt->execute([':id' => $itemId]);
}

if ($storeFile) {
    header('Location: ../articles.php?store=' . urlencode($storeFile));
} else {
    header('Location: ../start.php');
}
exit;
