<?php
declare(strict_types=1);

require __DIR__ . '/../auth.php';
requireLogin();

header('Content-Type: application/json; charset=utf-8');

$raw = file_get_contents('php://input');
$data = json_decode($raw, true);

$barcode = trim($data['barcode'] ?? '');
$storeFile = trim($data['storeFile'] ?? '');

if ($barcode === '') {
    echo json_encode(['ok' => false, 'error' => 'Kein Barcode empfangen.']);
    exit;
}

// Store finden
$stmt = $pdo->prepare("SELECT id FROM stores WHERE file = :file LIMIT 1");
$stmt->execute([':file' => $storeFile]);
$store = $stmt->fetch();

if (!$store) {
    echo json_encode(['ok' => false, 'error' => 'Store nicht gefunden.']);
    exit;
}

$storeId = (int)$store['id'];


// Prüfen ob Barcode registriert ist
$stmt = $pdo->prepare("
    SELECT p.id, p.name, p.default_unit
    FROM product_barcodes pb
    JOIN products p ON pb.product_id = p.id
    WHERE pb.barcode = :bc
");
$stmt->execute([':bc' => $barcode]);
$product = $stmt->fetch();

if ($product) {

    // sort_order bestimmen
    $stmt = $pdo->prepare("
        SELECT COALESCE(MAX(sort_order) + 1, 1)
        FROM items
        WHERE store_id = :sid
    ");
    $stmt->execute([':sid' => $storeId]);
    $sortOrder = (int)$stmt->fetchColumn();

    // Eintrag in items anlegen
    $stmt = $pdo->prepare("
        INSERT INTO items (product_id, store_id, name, amount, unit, price, sort_order)
        VALUES (:pid, :sid, :name, 1, :unit, 0.00, :sort)
    ");
    $stmt->execute([
        ':pid'  => $product['id'],
        ':sid'  => $storeId,
        ':name' => $product['name'],
        ':unit' => $product['default_unit'] ?? 'Stück',
        ':sort' => $sortOrder
    ]);

    echo json_encode([
        'ok'    => true,
        'known' => true,
        'msg'   => "Produkt gefunden: {$product['name']} – wurde zur Liste hinzugefügt."
    ]);
    exit;
}


// Produkt existiert noch nicht → Client soll Eingabe anzeigen
echo json_encode([
    'ok'         => false,
    'known'      => false,
    'barcode'    => $barcode,
    'msg'        => 'Barcode unbekannt – Produkt muss neu angelegt werden.'
]);
